/****** Object:  StoredProcedure [dbo].[usp_Insert_Discharge_Intent]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Insert_Discharge_Intent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Insert_Discharge_Intent]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII
-- Create date: 08.09.2011
-- Description:	Insert discharge intent.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Insert_Discharge_Intent] 
	@ID	INT OUTPUT,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@DATE_ENTERED DATETIME,
	@IS_ACTIVE BIT,
	@APPOINTMENT_DATE DATETIME,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,	
	@HOSPITAL_LOCATION_UID UNIQUEIDENTIFIER,	
	@STATUS NVARCHAR(MAX),
	@WARD_UID UNIQUEIDENTIFIER
AS
SET NOCOUNT ON

BEGIN

	INSERT INTO DISCHARGE_INT
	(
		DOMAIN_ID,
		PATIENT_UID,
		DATE_ENTERED,
		IS_ACTIVE,
		APPOINTMENT_DATE,
		VISTA_SITE_UID,
		HOSPITAL_LOCATION_UID,
		WARD_UID,
		STATUS
	)
	VALUES
	(
		@DOMAIN_ID,
		@PATIENT_UID,
		@DATE_ENTERED,
		@IS_ACTIVE,
		@APPOINTMENT_DATE,
		@VISTA_SITE_UID,
		@HOSPITAL_LOCATION_UID,
		@WARD_UID,
		@STATUS
	)

	SET @ID = IDENT_CURRENT('dbo.DISCHARGE_INT')
	
END
GO
